# 画面設計書 15-Number Formatting

## 概要

本ドキュメントは、VBCorLibのCorString.Format関数による数値フォーマット機能をデモンストレーションするNumber Formatting画面の設計書である。

### 本画面の処理概要

この画面は、.NET Frameworkと同等の数値フォーマット機能をVB6で利用する方法をデモンストレーションするアプリケーションである。CorString.Format関数を使用して、General（G）、Decimal（D）、Scientific（E）、Fixed（F）、Currency（C）、Number（N）、Hex（X）の各書式指定子による数値フォーマットをリアルタイムでプレビュー表示する。

**業務上の目的・背景**：VBCorLibが提供するCorString.Format関数の数値フォーマット機能をVB6開発者に紹介することを目的としている。この機能は.NET FrameworkのString.Formatと同様の書式指定子をサポートしており、VB6標準のFormat関数よりも高機能で柔軟な数値フォーマットが可能である。64ビット整数（CInt64）とFloating Point（Double）の両方に対応している。

**画面へのアクセス方法**：NumberFormatting.vbpプロジェクトをVB6 IDEで開き、実行（F5）することでフォームが起動する。スタートアップフォームとしてForm1が設定されている。

**主要な操作・処理内容**：
1. Numberテキストボックスに数値を入力
2. ラジオボタンで64-IntegerまたはFloatを選択
3. 入力値の変更に応じて、各書式指定子によるフォーマット結果がリアルタイムで更新
4. General、Decimal、Scientific、Fixed、Currency、Number、Hexの各フレーム内に結果を表示

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移は存在しない。

**権限による表示制御**：特になし。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | CorString | 主機能 | 数値フォーマット機能のデモ（Format関数でG、D、E、F、C、N、X書式を使用） |

## 画面種別

入力/プレビュー（リアルタイム変換）

## URL/ルーティング

該当なし（VB6デスクトップアプリケーション）

## 入出力項目

### 入力項目

| 項目名 | コントロール名 | データ型 | 必須 | 説明 |
|--------|---------------|----------|------|------|
| Number | txtInput | String | Yes | フォーマット対象の数値（文字列入力） |
| 数値型選択 | Option1/Option2 | Boolean | Yes | 64-IntegerまたはFloatの選択 |

### 出力項目（書式指定子別）

| フレーム | 項目名 | 書式指定子 | 説明 |
|----------|--------|-----------|------|
| General (G) | txtGeneral | {0:G} | 全桁表示（デフォルト） |
| General (G) | txtGeneral10 | {0:G10} | 最大10桁（超過時は指数表記） |
| General (G) | txtGeneral3 | {0:G3} | 有効数字3桁 |
| General (G) | txtGeneral3Lower | {0:g3} | 有効数字3桁（小文字e） |
| Decimal (D) | txtDecimal | {0:D} | 整数表示 |
| Decimal (D) | txtDecimal10 | {0:D10} | 10桁ゼロ埋め |
| Scientific (E) | txtExponent | {0:E} | 指数表記（大文字E） |
| Scientific (E) | txtExponentLower | {0:e} | 指数表記（小文字e） |
| Scientific (E) | txtExponent4 | {0:E4} | 小数点以下4桁 |
| Fixed (F) | txtFixed | {0:F} | 固定小数点（2桁） |
| Fixed (F) | txtFixed4 | {0:F4} | 小数点以下4桁 |
| Fixed (F) | txtFixed0 | {0:F0} | 小数点なし |
| Currency (C) | txtCurrency | {0:C} | 通貨形式 |
| Currency (C) | txtCurrency3 | {0:C3} | 通貨形式（小数点以下3桁） |
| Number (N) | txtNumber | {0:N} | 数値形式（2桁、カンマ区切り） |
| Number (N) | txtNumber0 | {0:N0} | 数値形式（カンマ区切り、小数なし） |
| Number (N) | txtNumber4 | {0:N4} | 数値形式（小数点以下4桁） |
| Hex (X) | txtHex | {0:X} | 16進数（大文字） |
| Hex (X) | txtHexLower | {0:x} | 16進数（小文字） |
| Hex (X) | txtHex2 | {0:X2} | 16進数（最小2桁） |
| Hex (X) | txtHex8 | {0:X8} | 16進数（8桁ゼロ埋め） |

## 表示項目

### 入力エリア

| 項目名 | 説明 |
|--------|------|
| Number | 数値入力テキストボックス |
| 64-Integer | 64ビット整数モード選択ラジオボタン |
| Float | 浮動小数点モード選択ラジオボタン |

### 出力フレーム（7種類）

各フレームに書式指定子のラベルと結果表示テキストボックスを配置。

## イベント仕様

### 1-txtInput_Change

数値入力テキストボックスの内容変更時に実行される。

**処理フロー**：
1. Update関数を呼び出し

### 2-Option1_Click / Option2_Click

数値型選択ラジオボタンクリック時に実行される。

**処理フロー**：
1. Update関数を呼び出し

### 3-Update（Private Sub）

全フォーマット結果を更新するメイン処理。

**処理フロー**：
1. On Error Resume Next（入力エラー対策）
2. Option1（64-Integer）選択時はCInt64で変換、Option2（Float）選択時はCDbl/Valで変換
3. mNumber変数に格納
4. 各フォーマット更新関数を呼び出し（UpdateGeneral〜UpdateHex）

### 4-UpdateGeneral（Private Sub）

General書式（G）のフォーマット結果を更新する。

**処理フロー**：
1. {0:G} - 全桁表示
2. {0:G10} - 最大10桁
3. {0:G3} - 有効数字3桁（大文字E）
4. {0:g3} - 有効数字3桁（小文字e）

### 5-UpdateDecimal（Private Sub）

Decimal書式（D）のフォーマット結果を更新する。整数型のみ対応。

**処理フロー**：
1. Float選択時は"N/A"を表示
2. {0:D} - 通常表示
3. {0:D10} - 10桁ゼロ埋め

### 6-UpdateScientific（Private Sub）

Scientific書式（E）のフォーマット結果を更新する。

**処理フロー**：
1. {0:E} - 指数表記（大文字E、7桁）
2. {0:e} - 指数表記（小文字e）
3. {0:E4} - 小数点以下4桁

### 7-UpdateFixed（Private Sub）

Fixed書式（F）のフォーマット結果を更新する。

**処理フロー**：
1. {0:F} - 固定小数点（デフォルト2桁）
2. {0:F4} - 小数点以下4桁
3. {0:F0} - 小数点なし

### 8-UpdateCurrency（Private Sub）

Currency書式（C）のフォーマット結果を更新する。

**処理フロー**：
1. {0:C} - 通貨形式（地域設定依存）
2. {0:C3} - 小数点以下3桁

### 9-UpdateNumber（Private Sub）

Number書式（N）のフォーマット結果を更新する。

**処理フロー**：
1. {0:N} - 数値形式（グループ区切り、2桁）
2. {0:N0} - 小数なし
3. {0:N4} - 小数点以下4桁

### 10-UpdateHex（Private Sub）

Hex書式（X）のフォーマット結果を更新する。整数型のみ対応。

**処理フロー**：
1. Float選択時は"N/A"を表示
2. {0:X} - 16進数（大文字）
3. {0:x} - 16進数（小文字）
4. {0:X2} - 最小2桁
5. {0:X8} - 8桁ゼロ埋め

## データベース更新仕様

該当なし（数値フォーマット表示のみ）

## メッセージ仕様

| 種別 | 条件 | メッセージ内容 |
|------|------|---------------|
| 表示 | Decimal/Hex書式でFloat選択時 | "N/A"を表示 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| 数値変換エラー | On Error Resume Nextで無視し、更新処理を継続 |

## 備考

- VBCorLib 3.0ライブラリ（vbcorlib3.dll）への参照設定が必要
- 追加のOCXは不要
- Currency書式は地域設定（Windowsの通貨設定）に依存
- Number書式のグループ区切りも地域設定に依存
- Decimal書式とHex書式は整数型のみ対応（Float選択時は"N/A"）
- CInt64関数でVB6の標準Integer/Long型を超える64ビット整数を扱える

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、数値フォーマット書式指定子の種類と意味を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Form1.frm（定数・変数宣言部） | `Examples/NumberFormatting/Format Integer/Form1.frm` | mNumber変数（Variant型）がフォーマット対象値を保持。64-IntegerまたはDoubleを格納 |

**読解のコツ**: .NET Frameworkの標準数値書式指定子と同等の機能を提供。G（General）、D（Decimal）、E（Exponential）、F（Fixed-point）、C（Currency）、N（Number）、X（Hexadecimal）の7種類。

#### Step 2: エントリーポイントを理解する

処理の起点となるイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/NumberFormatting/Format Integer/Form1.frm` | txtInput_Change、Option1_Click、Option2_Clickがトリガーとなり、Update関数を呼び出す |

**主要処理フロー**:
1. **行649-651（txtInput_Change）**: 数値入力変更時のトリガー
2. **行641-643（Option1_Click）**: 64-Integer選択時のトリガー
3. **行645-647（Option2_Click）**: Float選択時のトリガー
4. **行653-668（Update）**: 数値変換とフォーマット更新

#### Step 3: 各フォーマット処理の理解

7種類の書式指定子ごとの処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Form1.frm | `Examples/NumberFormatting/Format Integer/Form1.frm` | UpdateGeneral〜UpdateHexの各関数でCorString.Formatを呼び出し |

**主要処理フロー**:
- **行511-531（UpdateGeneral）**: G書式（全桁、桁数指定、大小文字）
- **行533-548（UpdateDecimal）**: D書式（整数のみ、ゼロ埋め）
- **行550-563（UpdateScientific）**: E書式（指数表記、大小文字）
- **行565-580（UpdateFixed）**: F書式（固定小数点、桁数指定）
- **行582-592（UpdateCurrency）**: C書式（通貨形式、地域依存）
- **行594-610（UpdateNumber）**: N書式（グループ区切り）
- **行612-639（UpdateHex）**: X書式（16進数、整数のみ）

### プログラム呼び出し階層図

```
Form1.frm
    │
    ├─ txtInput_Change (行649)
    │      └─ Update (行653)
    │
    ├─ Option1_Click (行641)
    │      └─ Update (行653)
    │
    └─ Option2_Click (行645)
           └─ Update (行653)
                  │
                  ├─ CInt64 または CDbl (数値変換)
                  │
                  ├─ UpdateGeneral (行511)
                  │      ├─ CorString.Format("{0:G}", mNumber)
                  │      ├─ CorString.Format("{0:G10}", mNumber)
                  │      ├─ CorString.Format("{0:G3}", mNumber)
                  │      └─ CorString.Format("{0:g3}", mNumber)
                  │
                  ├─ UpdateDecimal (行533)
                  │      ├─ CorString.Format("{0:D}", mNumber)
                  │      └─ CorString.Format("{0:D10}", mNumber)
                  │
                  ├─ UpdateScientific (行550)
                  │      ├─ CorString.Format("{0:E}", mNumber)
                  │      ├─ CorString.Format("{0:e}", mNumber)
                  │      └─ CorString.Format("{0:E4}", mNumber)
                  │
                  ├─ UpdateFixed (行565)
                  │      ├─ CorString.Format("{0:F}", mNumber)
                  │      ├─ CorString.Format("{0:F4}", mNumber)
                  │      └─ CorString.Format("{0:F0}", mNumber)
                  │
                  ├─ UpdateCurrency (行582)
                  │      ├─ CorString.Format("{0:C}", mNumber)
                  │      └─ CorString.Format("{0:C3}", mNumber)
                  │
                  ├─ UpdateNumber (行594)
                  │      ├─ CorString.Format("{0:N}", mNumber)
                  │      ├─ CorString.Format("{0:N0}", mNumber)
                  │      └─ CorString.Format("{0:N4}", mNumber)
                  │
                  └─ UpdateHex (行612)
                         ├─ CorString.Format("{0:X}", mNumber)
                         ├─ CorString.Format("{0:x}", mNumber)
                         ├─ CorString.Format("{0:X2}", mNumber)
                         └─ CorString.Format("{0:X8}", mNumber)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

txtInput ───────────────▶ txtInput_Change ─────────────▶ Update呼び出し
(数値入力)                (行649)
                              │
Option1/Option2 ────────▶ Option_Click ────────────────▶ Update呼び出し
(型選択)                  (行641, 645)
                              │
                              ▼
                         Update (行653)
                              │
                              ├─ CInt64/CDbl ──────────▶ mNumber
                              │   (数値変換)               (Variant)
                              │
                              ▼
                         UpdateGeneral〜UpdateHex
                              │
                              ├─ CorString.Format ─────▶ フォーマット文字列
                              │
                              └─ txtXxx.Text = ... ────▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/NumberFormatting/Format Integer/Form1.frm` | ソース | メインフォーム。UI定義と全フォーマット処理 |
| NumberFormatting.vbp | `Examples/NumberFormatting/Format Integer/NumberFormatting.vbp` | プロジェクト | VBプロジェクトファイル |
| vbcorlib3.dll | `Binaries/Compiled/vbcorlib3.dll` | ライブラリ | VBCorLibランタイム |
